@echo off
rem =======================================================================================
rem USAGE:
rem for DUP: add_intelppm.bat
rem for FI: add_intelppm.bat <ppm_file_dir>\ . Example: add_intelppm.bat c:\dell\K80H4\
rem ========================================================================================

set myReturnCode=0
set myReturnCodeName=SUCCESS
set ERRORLEVEL=0

:CHECK_OS
rem OS WinMajorBuild: WIN10 19041-19045, WIN11_21H2 22000, WIN11_22H2 22621, WIN11_23H2 22631, WIN11_24H2 26100

for /f "tokens=4-7 delims=[.] " %%i in ('ver') do (if %%i==Version (
        rem set OSVer=%%j.%%k.%%l.%%m
        set WinMajorBuild=%%l
        set WinMinorBuild=%%m
    ) else (
	    rem set OSVer=%%i.%%j.%%k.%%l
		set WinMajorBuild=%%k
        set WinMinorBuild=%%l
	)
)

echo Windows Version = %WinMajorBuild%.%WinMinorBuild%


:CHECK_CPU
rem myCPU: SPR, MTL, RPL, ADL-N, ADL, TGL, PPM inf-based-supported (LNL, ARL and later)
set myCPU=inf-based-supported

(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 143") && (set myCPU=SPR) && (goto FILEPATH)

(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 170") && (set myCPU=MTL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 172") && (set myCPU=MTL) && (goto FILEPATH)

(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 183") && (set myCPU=RPL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 186") && (set myCPU=RPL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 191") && (set myCPU=RPL) && (goto FILEPATH)

(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 151") && (set myCPU=ADL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 154") && (set myCPU=ADL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 190") && (set myCPU=ADL-N) && (goto FILEPATH)

(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 140") && (set myCPU=TGL) && (goto FILEPATH)
(echo %PROCESSOR_IDENTIFIER%| find "Family 6 Model 141") && (set myCPU=TGL) && (goto FILEPATH)

rem return 20 for DUP (ERROR_INSTALL_PLATFORM_UNSUPPORTED) (DU not support non-zero ReturnCode yet)
rem set myReturnCode=20
rem set myReturnCodeName=ERROR_INSTALL_PLATFORM_UNSUPPORTED

rem goto END


:FILEPATH
rem echo CPU = %myCPU%

set myFile=inbox

if "%myCPU%"=="inf-based-supported" (
    set myFile=inf-based
    goto INSTALL
)

if "%myCPU%"=="MTL" (
    
	if %WinMajorBuild% geq 26100 (
	    rem Win11 24H2 or above
	    set myFile=PPM-MTL-ARL-v1007.20241022.ppkg
    ) else if %WinMajorBuild% geq 22621 (
        rem Win11 22H2 and 23H2
	    set myFile=PPM-MTL-ARL-23H2-v1007.20241021.ppkg
    ) else (
        rem Win11 21H2 and Win10
	    set myFile=PPM-MTL-ARL-win10-v1000.20241017.ppkg
	)
	
    goto INSTALL
)

if "%myCPU%"=="RPL" (
    if %WinMajorBuild% geq 22621 (
	    rem Win11 22H2 or above
	    set myFile=PPM-RPL-preview-v1003.20240717.ppkg
    ) else (
        rem Win10 or Win11 21H2
	    set myFile=PPM-Win10-preview-v1000.20240612.ppkg
	)
    goto INSTALL
)

if "%myCPU%"=="ADL-N" (

    if %WinMajorBuild% geq 22000 (
        rem Win11
	    set myFile=PPM-ADL-preview-v1001.20240717.ppkg
    ) else (
	    rem Win10
	    set myFile=PPM-ADL-N-preview-v1000.20220719.ppkg
	)
    goto INSTALL
)

if "%myCPU%"=="ADL" (
    if %WinMajorBuild% geq 22000 (
        rem Win11
	    set myFile=PPM-ADL-preview-v1001.20240717.ppkg
    ) else (
	    rem Win10
	    set myFile=PPM-Win10-preview-v1000.20240612.ppkg
	)

    goto INSTALL
)

if "%myCPU%"=="TGL" (
    set myFile=PPM-TGL-preview-v9.402.ppkg

    goto INSTALL
)

if "%myCPU%"=="SPR" (
    if %WinMajorBuild% geq 22621 (
	    rem Win11 22H2 or above
	    set myFile=PPM-SPR-preview-v2000.20231027.ppkg
    )
    goto INSTALL
)

:INSTALL

if [%1] == [] (
	set myPPMPath="%~dp0%myFile%"
	set mydel_Ps1Path="%~dp0del_Intelppm.ps1"
	set mychk_Ps1Path="%~dp0chk_Intelppm.ps1"
	set myInfPath="%~dp0inf-based\*.inf"
)else (
	set myPPMPath="%1%myFile%"
	set mydel_Ps1Path="%1del_Intelppm.ps1"
	set mychk_Ps1Path="%1chk_Intelppm.ps1"
	set myInfPath="%1inf-based\*.inf"
)

rem Uninstall old PPM
PowerShell -NoProfile -ExecutionPolicy Bypass -Command "& '%mydel_Ps1Path%'";

rem Install PPM

if "%myFile%"=="inf-based" (
    pnputil /add-driver %myInfPath% /install
	goto DISM_PPM
)

if exist %myPPMPath% (
    echo PPM file = %myFile%
    provtool %myPPMPath% /quiet
)

goto END

:DISM_PPM
rem wait 5 sec for PPM file to be copied to the folder
timeout /t 5 /nobreak >nul
PowerShell -NoProfile -ExecutionPolicy Bypass -Command "& '%mychk_Ps1Path%'"

:END

if not %ERRORLEVEL% == 0 (
	exit 1
)



rem
rem Set Registry for Inventory
rem

set PPM_KEY="HKLM\SOFTWARE\Dell\ManageableUpdatePackage\IntelPPM"
set PPM_NAME="Intel Common PPM Package"
set PPM_VERSION=9.0.0

reg add %PPM_KEY% /f
reg add %PPM_KEY% /v Product_Name /t REG_SZ /d %PPM_NAME% /f
reg add %PPM_KEY% /v Product_Version /t REG_SZ /d %PPM_VERSION% /f
reg add %PPM_KEY% /v ReturnCode_Name /t REG_SZ /d %myReturnCodeName% /f


exit myReturnCode




