/*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2021 Intel Corporation All Rights Reserved
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** Title to the Material remains with Intel Corporation or its suppliers and
** licensors. The Material contains trade secrets and proprietary and
** confidential information of Intel or its suppliers and licensors, and is
** protected by worldwide copyright and trade secret laws and treaty
** provisions. No part of the Material may be used, copied, reproduced,
** modified, published, uploaded, posted, transmitted, distributed, or disclosed
** in any way without Intels prior express written permission.
**
** No license under any patent, copyright, trade secret or other intellectual
** property right is granted to or conferred upon you by disclosure or delivery
** of the Materials, either expressly, by implication, inducement, estoppel or
** otherwise. Any license under such intellectual property rights must be
** express and approved by Intel in writing.
**
*******************************************************************************/
/*++

Module Name:

    FlipMode.h

Abstract:

    This module contains the macro and data structures used for WMI Flip mode interface.

Environment:

    kernel

*/

#pragma once

//
// Define an Guid of the WMI event defined in the MOF file of customer.
//
// {8B8E7170-6338-4a39-82F6-3D497BC97C96}
DEFINE_GUID(GUID_OEM_FLIPMODE_WMI_EVENT,
    0x8B8E7170, 0x6338, 0x4a39, 0x82, 0xF6, 0x3D, 0x49, 0x7B, 0xC9, 0x7C, 0x96);

#define MAX_ANGLE_FOR_EVENT 360

//
// Define the data structure of the flip status according to the data
// block in the MOF file of customer.
//
typedef struct _FLIP_ANGLE
{
    // Current angle for flip
    // Between 0-360
    UINT Angle;
} OEM_FLIP_ANGLE, *POEM_FLIP_ANGLE;


//
// Define an Guid of the WMI data block of device state defined in the MOF file of customer.
//
// {34DDEC73-F3B3-4251-8227-BF6D8816B96F}
DEFINE_GUID(GUID_OEM_CURANGLE_WMI_EVENT,
    0x34DDEC73, 0xF3B3, 0x4251, 0x82, 0x27, 0xBF, 0x6D, 0x88, 0x16, 0xB9, 0x6F);

typedef
NTSTATUS
(*PQUERY_ANGLE_STATE)(
    PVOID Context,
    UINT *FlipAngle
    );

