/******************************************************************************
 INTEL CONFIDENTIAL
 Copyright 2021 Intel Corporation All Rights Reserved.

 The source code contained or described herein and all documents related to the
 source code ("Material") are owned by Intel Corporation or its suppliers or
 licensors. Title to the Material remains with Intel Corporation or its
 suppliers and licensors. The Material may contain trade secrets and proprietary
 and confidential information of Intel Corporation and its suppliers and
 licensors, and is protected by worldwide copyright and trade secret laws and
 treaty provisions. No part of the Material may be used, copied, reproduced,
 modified, published, uploaded, posted, transmitted, distributed, or disclosed
 in any way without Intel's prior express written permission.

 No license under any patent, copyright, trade secret or other intellectual
 property right is granted to or conferred upon you by disclosure or delivery
 of the Materials, either expressly, by implication, inducement, estoppel or
 otherwise. Any license under such intellectual property rights must be express
 and approved by Intel in writing.

 Unless otherwise agreed by Intel in writing, you may not remove
 or alter this notice or any other notice embedded in Materials by
 Intel or Intel's suppliers or licensors in any way.

******************************************************************************/


/**
 * This module contains the vendor internal interface definitions.
 */

#ifndef _HDMI_I2S_Interface_H_Included
#define _HDMI_I2S_Interface_H_Included

#include <minwindef.h>

// {C8ECFA50-5F08-4057-9F2B-8944BA5FCA52}
static const GUID INTC_HDMI_I2S_HW_CODEC_PRIVATE_INTERFACE_GUID =
{ 0xc8ecfa50, 0x5f08, 0x4057, { 0x9f, 0x2b, 0x89, 0x44, 0xba, 0x5f, 0xca, 0x52 } };

static const USHORT INTC_HDMI_I2S_HW_CODEC_PRIVATE_INTERFACE_VERSION = 1;

typedef NTSTATUS (*HDMI_I2S_SET_JACK_STATE)(
    _In_ PVOID _Context,    // interface context
    _In_ UCHAR _HdmiIdx,    // hdmi input index (0,1,2,3)
    _In_ UCHAR _JackState   // hdmi input jack state (0=uplugged/1=plugged)
);

typedef struct _INTC_HDMI_I2S_HW_CODEC_PRIVATE_INTERFACE
{
    INTERFACE               InterfaceHeader;
    HDMI_I2S_SET_JACK_STATE HdmiI2sSetJackState;
} INTC_HDMI_I2S_HW_CODEC_PRIVATE_INTERFACE, *PINTC_HDMI_I2S_HW_CODEC_PRIVATE_INTERFACE;

#endif // _HDMI_I2S_Interface_H_Included
