﻿/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#ifndef _BIOS_INTERFACE_H
#define _BIOS_INTERFACE_H

#include "InterfacesCommon.h"
//#include "public.h"
#include "SensorDataInterface.h"

#pragma pack(1)
typedef struct _SENSOR_DRIVER_VIEW
{
    UCHAR Version;                               // Current (first) version is 0x00

    UCHAR SensorCardSKU;                         // Sensor Card SKU

    CSI2_HOST_CONTROLLER   HostController;       // Identifies to which host controller this sensor is connected

    HOST_CONTROLLER_GLOBAL HostControllerGlobal; // This (same) structure is provided by the BIOS to each of the sensor drivers as part of its ACPI resources (hence it is
                                                 // global and not per sensor).
                                                 // The sensor driver provides it to the AVStream driver, and the AVStream driver provides it to the CSI2 HC driver with
                                                 // every sensor link that it wants to create.

    UCHAR LinkUsed;                            // Link used by this sensor stream. The value for each of the platform sensors depends on platform routing. Valid numbers are:
                                            //        0 - This sensor uses link0. A high resolution sensor that uses two links must put in this field a value of 0 and LanesUsed is 8.
                                            //        1 - This sensor uses link1
                                            //        2 - This sensor uses link2
                                            //        3 - This sensor uses link3
                                            // Values other than the listed are not supported.
                                            // The Sensor driver receives from the BIOS as part of its ACPI resources the LinkUsed parameter. The sensor driver reports to the AVStream driver the
                                            // LinkUsed and the AVStream driver reports it to the CSI2 HC driver.

    UCHAR LanesUsed;                        // Number of lanes connected for this sensor. The value for each of the platform sensors depends on platform routing. However even if a sensor is connected to
                                            // number of lanes, it still can be used with a smaller number of lanes. It is the decission of its sensor driver how many lanes to use. This decission
                                            // may be based on the selected resolution and frame rate based on power calculations at the sensor driver. This means that this setting may vary based
                                            // on sensor settings. Valid numbers are:
                                            //        1 - One lane
                                            //        2 - Two lanes
                                            //        3 - Three lanes
                                            //        4 - Four lanes
                                            //        8 - Eight lanes (requires CSI2 HC to be in 'channel merging' mode. Selection of 8 lanes is possible only for high resolution sensor, and requires
                                            //            also that LinkUsed is 0. In addition in this mode, Channel Merging mode parameter is required (see below).
                                            // Values other than the listed are not supported.
                                            //
                                            // The Sensor driver receives from the BIOS as part of its ACPI resources the ActualNumberOfLanes. The sensor driver reports to the AVStream driver the
                                            // LanesUsed per sensor driver decission (LanesUsed must be < ActualNumberOfLanes) and the AVStream driver reports it to the CSI2 HC driver.

    LINK_DELAY_PARAMETERS LinkDelayParameters;// These are platform parameters that should set registers 0x24 ?0x48 of the CSI2-FE of the link. They have to be configured according to the sensor抯
                                            // specific parameters! BIOS provides this table to the sensor driver as part of the ACPI resources of the sensor. The sensor driver has to provide these values to the CSI2 driver through the AVStream driver.
                                            // The values are not only sensor specific, but are platform routing specific and are result of measurements and tuning (there can be different distances even for lanes of same link), so some lanes have to
                                            // add delays that are platform related). Mostly Settle time is important. Termination time can be 0.

    ULONG MaxLaneSpeed;                        // Maximum lane speed that is supported on this platform. This parameter is a result of platform validation at the OEM and is defined to allow limiting the
                                            // MIPI data rate in case the platform routing results with errors in higher speeds. This parameter is provided to the sensor driver by the BIOS as part of
                                            // the sensor's ACPI resources. The sensor driver should use this parameter to limit its sensor MIPI speed accordingly. The sensor driver would
                                            // decide what is the sensor's MIPI speed per the required settings (may use different speed per resolution or power calculations) and provide its current
                                            // link speed parameter within this structure member per its settings to the AVStream driver which will forward it to the CSI2 HC driver. The CSI2 HC driver
                                            // use this parameter as the current link speed and not the MAX link speed and may use it with LanesUsed and the values that it receives from the other
                                            // sensors along with number of active links to calculate the SRAM watermarks and the LTR values.
                                            // Values are in bits/sec. Examples:
                                            //        1000000000 - 1000Mbps (1Gbps)
                                            //        1500000000 - 1500Mbps (1.5Gbps) - this is the typical maximum speed for MIPI CSI2

    UCHAR SensorCalibrationFileIndex[1];
    UCHAR SensorCalibrationFileIndexMBZ[3];
    union
    {
        UCHAR Reserved[30];
        SKC_SENSOR_DRIVER_SUBDB_VIEW SensorDriverSubView;
    };
} SENSOR_DRIVER_VIEW, *PSENSOR_DRIVER_VIEW;
#pragma pack()

#pragma pack(1)
typedef struct _BIOS_VIEW
{
    UCHAR BIOS_Buffer[sizeof(SENSOR_DRIVER_VIEW)];
} BIOS_VIEW, *PBIOS_VIEW;
#pragma pack()

#pragma pack(1)
typedef union _BIOS_TO_SENSOR
{
    SENSOR_DRIVER_VIEW SensorDriverView;
    BIOS_VIEW            BIOS_View;
} BIOS_TO_SENSOR, *PBIOS_TO_SENSOR;
#pragma pack()

#define BIOS_SSDB_SIZE      0x6C     //108 bytes

#define DEFINEVALUE2STRING_WORK(x) DEFINE2STRING(x)

static_assert(sizeof(SENSOR_DRIVER_VIEW) == BIOS_SSDB_SIZE,
    "sizeof SENSOR_DRIVER_VIEW should be synchronized with ACPI BIOS SSDB size (current size is " DEFINEVALUE2STRING_WORK(BIOS_SSDB_SIZE) ")");



#endif  //_BIOS_INTERFACE_H
