//***********************************************************************
//*                        INTEL CONFIDENTIAL                           *
//***********************************************************************
// Copyright 2014 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents
// related to the source code ("Material") are owned by Intel
// Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors.
// The Material may contain trade secrets and proprietary and
// confidential information of Intel Corporation and its suppliers and licensors,
// and is protected by worldwide copyright and trade secret
// laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted,
// transmitted, distributed, or disclosed in any way without Intels
// prior express written permission.
//
// No license under any patent, copyright, trade secret or other
// intellectual property right is granted to or conferred upon you by
// disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under
// such intellectual property rights must be express and approved by
// Intel in writing.

/** @file InterfacesCommon.h */

#pragma once

// This file contains various data structures that are common to multiple interfaces. These include:
// 1. Data structures for uniquely identifying a single sensor device within a host controller (I/O driver)
// 2. Data structures for uniquely identifying a single host controller device
#include "public.h"

#if defined(__cplusplus)
extern "C" {
#endif

//#include <Wdm.h>

#if defined(__cplusplus)
}
#endif

//typedef unsigned long ULONG;
//typedef unsigned long long ULONGLONG;
//typedef unsigned short USHORT;
//typedef unsigned long STATUS;
//typedef void* PVOID;

#define HOST_CONTROLLER_MOCK_INSTANCE_ID         0x5566
#define IVCAM_USB_HOST_CONTROLLER_INSTANCE_ID    0x1CA8
#define CSI2_HOST_CONTROLLER_DEFAULT_INSTANCE_ID 0xA3

/*******************
* \brief Identifies a single link to a CSI3 sensor in a specific CSI3 host controller
*
* A unique configuration information that identifies a link to a CSI3 sensor on a specific CSI3 host controller, including the link, lanes and more...
*
*******************/
        /*
        Sensor: // 0 1 2 3
            000 // 4 4 2 2
            001 // Reserved
            010 // 4 4 3 1
            011 // 4 4 4 0
            100 // 8 0 2 2
            101 // Reserved
            110 // 8 0 3 1
            111 // 8 0 4 0
        */
//	ULONG VC; //TODO: need to discuss again alocation


/*******************
* \brief Identifies a single connection to a USB sensor from the USB host controller
*
* A unique configuration information that identifies a connection to a USB sensor on a specific CSI3 host controller. Detailed TBD
*
*******************/


/*******************
* \brief Union for all possbile link configurations. Represents a single sensor connection (=link)
*
* Contains all possible port configuration (CSI3, USB). Intended as a container for transferring the configuration between different entities.
*
*******************/

// A unique identifier for a single CSI2 host controller
// Typically, this structure is provided as ACPI resource for a specific sensor
// {8A395669-11F7-4ea9-9C7D-20EE0AB5CA40}
DEFINE_GUID(CSI2DataStreamInterfaceGUID, 0x8a395669, 0x11f7, 0x4ea9, 0x9c, 0x7d, 0x20, 0xee, 0xa, 0xb5, 0xca, 0x40);




/*******************
* \brief Union for all possbile port configurations
*
* Contains all possible host controllers (CSI3, USB). Intended as a container for transferring the configuration between different entities.
*
*******************/

/*******************
* \brief Unique identifier for a connection to a sensor
*
* Contains identifier to a specific host controller and a specific sensor (represented as Port) connected to that host controller.
*
*******************/

typedef enum _INTERFACE_STATE
{
    IFC_DISCONNECTED,
    IFC_STOPPED,
    IFC_CONFIGURED,
    IFC_RUNNING
} INTERFACE_STATE;

#define IS_IFC_CONNECTED(state)             (state >= IFC_STOPPED)
#define IS_IFC_CONFIGURED_OR_HIGHER(state)  (state >= IFC_CONFIGURED)
#define IS_IFC_RUNNING(state)               (state == IFC_RUNNING)
