/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2021 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/


#ifndef _CONTROLLOGIC_SENSOR_INTF_H
#define _CONTROLLOGIC_SENSOR_INTF_H

#include "controllogic_common.h"

/*!
* \brief controllogic driver interface version
*
* \ver.0 First version
* 
*/
#define CONTROLLOGIC_SENSOR_INTERFACE_VERSION       2

#define SENSOR_INTERFACE_VER0 0
#define SENSOR_INTERFACE_VER1 1    // in SSDB, SSDB definition version

#define PRIVACY_LED_A 0
#define PRIVACY_LED_B 1



#define LED_CURRENT_2mA 0x0
#define LED_CURRENT_4mA 0x1
#define LED_CURRENT_8mA 0x2
#define LED_CURRENT_16mA 0x3

#define CAMERA_POSITION_1  0 /*!< The left position of the CRD-G2 Card */
#define CAMERA_POSITION_2  1 /*!< The right position of the CRD-G2 Card */
#define CAMERA_POSITION_3  2 /*!< The shared power rail sensor of the CRD-G3 Card */

/*!
* \brief  Interface Standard GUID
*
* \{B819D8C7-F09C-4381-BF8A-D312276D08E6}
*/
static const GUID ControlLogicSensorInterfaceStandard =
{ 0xB819D8C7, 0xF09C, 0x4381, { 0xBF, 0x8A, 0xD3, 0x12, 0x27, 0x6D, 0x08, 0xE6 } };

typedef enum _HDMI_STATUS
{
    HDMI_RESOLUTION_CHANGE,
    HDMI_PLUG_OFF
} HDMI_STATUS;

typedef enum _SENSOR_CALLBACK_TYPE
{
    SENSOR_CALLBACK_HDMI_STATUS_CHANGE
} SENSOR_CALLBACK_TYPE_ID;

typedef NTSTATUS (*PSENSOR_SET_HDMI_CB)(
    void *Context,
    ULONG hdmiStatus    // enum value from HDMI_STATUS
    );

typedef struct _SENSOR_CB_HDMI_STATUS_UPDATE
{
    PSENSOR_SET_HDMI_CB Callback;
    PVOID Context;
} SENSOR_CB_HDMI_STATUS_UPDATE;

/*
*Parameter:
*RESET: sensor just needs one pin to reset
*RESET_POWERDOWN: sensor needs two pins to reset
*/
typedef enum _GPIOUSAGE{
    RESET,
    RESET_POWERDOWN
}GPIOUSAGE;

//Voltage Config
typedef struct voltage_cfg_t
{
    UINT16 VD; /* CORE_OUT ?*/
    UINT16 VA; /* Sensor Analog output*/
    UINT16 VIO; /* IO_OUT  IO LDO output */
    UINT16 VCM; /* VCM_OUT  VCM LDO output */
    UINT16 V_SIO; /* Sensor IO LDO output */
}voltage_cfg_t;

typedef struct privacy_led_cfg_t
{
    ULONG sensor_interface_version;
    ULONG privacyLed;
    ULONG privacyLedCurrent;
    ULONG CamPosition;     
}privacy_led_cfg_t;

typedef struct _SENSOR_CONF
{
    ULONG Pld;        //sensor location
    ULONG Mclk;
    voltage_cfg_t volConf;
    ULONG Votage_rail;
    privacy_led_cfg_t ledConf;
    union
    {
        ULONG SysPowerAction;
        ULONG Reserved[5];  // Reserved[1]: Default Privacy indicator status:  WA for Dell Andrew Cam_Active Design
    };
}SENSOR_CONF, *PSENSOR_CONF;

/*
* Set Sensor PowerOn
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Configuration[in]: Configuration for voltage and other measurement, set NULL to use default parameter. 
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/
typedef NTSTATUS(*PFN_SENSOR_INITIALIZE)(
    _In_ PVOID DeviceContext,
    _In_ PVOID Configuration
    );

/*
* Set Sensor PowerOn
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Configuration[in]: Configuration for voltage and other measurement, set NULL to use default parameter. 
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/
typedef NTSTATUS(*PFN_SENSOR_ON)(
    _In_ PVOID DeviceContext,
    _In_ PVOID Configuration
    );

/*
* Set Sensor PowerOff
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Configuration[in]: Configuration for voltage and other measurement, set NULL to use default parameter.
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/
typedef NTSTATUS(*PFN_SENSOR_OFF)(
    _In_ PVOID DeviceContext,
    _In_ PVOID Configuration
    );

/*
* PrivacyLed Operation
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Configuration[in]: Configuration for voltage and other measurement, set NULL to use default parameter.
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/
typedef NTSTATUS(*PFN_PRIVCAYLED_OPERATION)(
    _In_ PVOID DeviceContext,
    _In_ PVOID Configuration
    );

/*
*Set value to specified register
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Address[in]: Register Address
* Value[in]: register value
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/

typedef NTSTATUS(*PFN_SET_REGISTER)(
    _In_ PVOID DeviceContext,
    _In_ UINT16 Address,
    _In_ ULONG Value 
    );

/*
*Get Get specified register value
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* Address[in]: regsiter address
* Value[out]: register value
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/

typedef NTSTATUS(*PFN_GET_REGISTER)(
    _In_ PVOID DeviceContext,
    _In_ UINT16 Address,
    _Out_  ULONG* Value
    );

/*
*Get ControlLogic Info
*Parameters:
* Context[in]: Pointer to device context defined with structure DEVICE_CONTEXT
* info[out]: for pmic infomation 
* Return Value:
* STATUS_SUCCESS if the operation success
* Corresponding status code if unexpected event happens
*/

typedef NTSTATUS(*PFN_GET_INFO)(
    _In_ PVOID DeviceContext,
    _Out_ CONTROLLOGIC_INFO* info 
    );

typedef VOID(*PFN_SET_IDLE) (
    _In_ PVOID Context
    );

typedef  VOID(*PFN_SET_ACTIVE) (
    _In_ PVOID Context
    );

typedef NTSTATUS(*PFN_SET_CALLBACK) (
    _In_ PVOID Context,
    _In_ SENSOR_CALLBACK_TYPE_ID callbackID,
    ULONG_PTR callback
    );


typedef struct _PMIC_SENSOR_INTERFACE
{
    INTERFACE                           InterfaceHeader;
    
    /*
    *  Sensor Initialize
    */
    
    PFN_SENSOR_INITIALIZE              Initialize;


    /*
    * Sensor Control
    */
    PFN_SENSOR_ON                       SensorOn;
    PFN_SENSOR_OFF                      SensorOff;

    /*
    * PrivacyLed Control
    */
    PFN_PRIVCAYLED_OPERATION            PrivacyLedOn;
    PFN_PRIVCAYLED_OPERATION            PrivacyLedOff;
    

    /*
    * Register Control
    */
    PFN_SET_REGISTER                    SetRegister;
    PFN_GET_REGISTER                    GetRegister;
    
    /*
    * Get Pmic Information
    */
    PFN_GET_INFO                        GetControlLogicInfo;

    PFN_SET_ACTIVE                      SetActive;
    PFN_SET_IDLE                        SetIdle;

    PFN_SET_CALLBACK                    SetCallback;

} CONTROLLOGIC_SENSOR_INTERFACE;

#endif
