/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2019-2022 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
/*

Module Name:

        dsdt.h

Abstract:

Author:

Environment:

--*/

#ifndef __CAMERA_DSDT__
#define __CAMERA_DSDT__

#include <ntifs.h>
#include <ntddk.h>
#include <wdf.h>
#define NTSTRSAFE_LIB
#include <ntstrsafe.h>
#include <spb.h>
#include <Acpiioct.h>
#include <reshub.h>

#define VERSION_0 0     // currently used & recommended
#define VERSION_1 1     // deprecated design
#define VERSION_2 2     // deprecated design

#define DSDT_INTERFACE_VERSION VERSION_2

// 377BA76A-F390-4AFF-AB38-9B1BF33A3015
static const GUID DsmHardwareId =
{ 0x377BA76A, 0xF390, 0x4AFF, { 0xAB, 0x38, 0x9B, 0x1B, 0xF3, 0x3A, 0x30, 0x15 } };

// 26257549-9271-4CA4-BB43-C4899D5A4881
static const GUID DsmI2c =
{ 0x26257549, 0x9271, 0x4CA4, { 0xBB, 0x43, 0xC4, 0x89, 0x9D, 0x5A, 0x48, 0x81 } };

// 79234640-9E10-4FEA-A5C1-B5AA8B19756F
static const GUID DsmGpio =
{ 0x79234640, 0x9E10, 0x4FEA, { 0xA5, 0xC1, 0xB5, 0xAA, 0x8B, 0x19, 0x75, 0x6F } };

// B65AC492-9E30-4D60-B5B2-F497C790D9CF
static const GUID DsmSnsrFunction =
{ 0xB65AC492, 0x9E30, 0x4D60, { 0xB5, 0xB2, 0xF4, 0x97, 0xC7, 0x90, 0xD9, 0xCF } };

// E770AB0F-2644-4BAB-8628-D62F1683FB9D
static const GUID DsmSnsrRom =
{ 0xE770AB0F, 0x2644, 0x4BAB, { 0x86, 0x28, 0xD6, 0x2F, 0x16, 0x83, 0xFB, 0x9D } };

// 822ACE8F-2814-4174-A56B-5F029FE079EE
static const GUID DsmSnsrModule =
{ 0x822ace8f, 0x2814, 0x4174, { 0xa5, 0x6b, 0x5f, 0x2, 0x9f, 0xe0, 0x79, 0xee } };

// 2959512A-028C-4646-B73D-4D1B5672FAD8
static const GUID DsmPlatInfo =
{ 0x2959512a, 0x28c, 0x4646, { 0xb7, 0x3d, 0x4d, 0x1b, 0x56, 0x72, 0xfa, 0xd8 } };

// EA3B7BD8-E09B-4239-AD6E-ED525F3F26AB
static const GUID DsmSnsrMipiPort =
{ 0xea3b7bd8, 0xe09b, 0x4239, { 0xad, 0x6e, 0xed, 0x52, 0x5f, 0x3f, 0x26, 0xab } };

// 75C9A639-5C8A-4A00-9F48-A9C3B5DA789F
static const GUID DsmVcmName =
{ 0x75C9A639, 0x5C8A, 0x4A00, { 0x9F, 0x48, 0xA9, 0xC3, 0xB5, 0xDA, 0x78, 0x9F } };

// {E9914EB6-592B-4228-BA5D-A0994BCB20DD}
static const GUID DsmSnsrCalibration =
{ 0xE9914EB6, 0x592B, 0x4228, { 0xba, 0x5d, 0xa0, 0x99, 0x4b, 0xcb, 0x20, 0xdd } };

// {5E95D048-B1DE-4590-947D-CC699940CEE4}
static const GUID DsmFlashFunction =
{ 0x5e95d048, 0xb1de, 0x4590, { 0x94, 0x7d, 0xcc, 0x69, 0x99, 0x40, 0xce, 0xe4 } };

// {1EA54AB2-CD84-48CC-9DD4-7F594EC3B015}
static const GUID DsmInterfaceVersion =
{ 0x1EA54AB2, 0xCD84, 0x48CC, { 0x9D, 0xD4, 0x7F, 0x59, 0x4E, 0xC3, 0xB0, 0x15 } };

// {2FA9BB94-9C5D-4AEB-8E6E-27434F81E3D3}
static const GUID Dsm2PlatformStr =
{ 0x2fa9bb94, 0x9c5d, 0x4aeb, { 0x8e, 0x6e, 0x27, 0x43, 0x4f, 0x81, 0xe3, 0xd3 } };

// {647A6CA2-8B29-49AC-8806-D58B3D2D3EF5}
static const GUID Dsm2PlatformSubStr =
{ 0x647a6ca2, 0x8b29, 0x49ac, { 0x88, 0x6, 0xd5, 0x8b, 0x3d, 0x2d, 0x3e, 0xf5 } };

// {A6E922A1-F7B3-4399-B56A-406AE416843B}
static const GUID Dsm2SiliconStr =
{ 0xa6e922a1, 0xf7b3, 0x4399, { 0xb5, 0x6a, 0x40, 0x6a, 0xe4, 0x16, 0x84, 0x3b } };

// {5960313B-0AB0-4940-8840-2CAFA420C015}
static const GUID Dsm2CustomerStr =
{ 0x5960313b, 0xab0, 0x4940, { 0x88, 0x40, 0x2c, 0xaf, 0xa4, 0x20, 0xc0, 0x15 } };

// {F486D39F-D657-484B-84A6-42A565712B92}
static const GUID Dsm2Information =
{ 0xf486d39f, 0xd657, 0x484b, { 0x84, 0xa6, 0x42, 0xa5, 0x65, 0x71, 0x2b, 0x92 } };

// {EB1B739E-A439-4247-A72B-98BB2B2E3442}
static const GUID DsmPmicInfo =
{ 0xEB1B739E, 0xA439, 0x4247, { 0xA7, 0x2B, 0x98, 0xBB, 0x2B, 0x2E, 0x34, 0x42 } };

//{18162FAB-1B16-481D-9879-75E285B302B1}
static const GUID DsmPmicLinkInfo =
{ 0x18162FAB, 0x1B16, 0x481D, { 0x98, 0x79, 0x75, 0xE2, 0x85, 0xB3, 0x02, 0xB1 } };

//{8B560FF0-FD87-470E-83FE-DB626271D474}
static const GUID DsmSKCBoardType =
{ 0x8B560FF0, 0xFD87, 0x470E, { 0x83, 0xFE, 0xDB, 0x62, 0x62, 0x71, 0xD4, 0x74 } };

#ifdef BXT
// 8DBE2651-70C1-4C6F-AC87-A37CB46E4AF6
static const GUID DsmSnsrMclk =
{ 0x8DBE2651, 0x70C1, 0x4C6F, { 0xAC, 0x87, 0xA3, 0x7C, 0xB4, 0x6E, 0x4A, 0xF6 } };
#else
//{36FD87B5-7C5A-43C7-955E-F009B4CBF95C}
static const GUID DsmSnsrMclk =
{ 0x36FD87B5, 0x7C5A, 0x43C7, { 0x95, 0x5E, 0xF0, 0x09, 0xB4, 0xCB, 0xF9, 0x5C } };
#endif

// {952DB6F5-B3DA-473C-9A1B-1DDBB27DA9B4}
static const GUID DsmFuncPowerD0 =
{ 0x952db6f5, 0xb3da, 0x473c, { 0x9a, 0x1b, 0x1d, 0xdb, 0xb2, 0x7d, 0xa9, 0xb4 } };

// {239ABA6F-46F9-4884-B67C-0B1D84DC585C}
static const GUID DsmFuncPowerD3 =
{ 0x239aba6f, 0x46f9, 0x4884, { 0xb6, 0x7c, 0xb, 0x1d, 0x84, 0xdc, 0x58, 0x5c } };

#if 0 // not used in BXT project
// 918AB242-C37C-450A-9D0F-F47AB97C3DEA
static const GUID DsmSnsrMipiLane =
{ 0x918AB242, 0xC37C, 0x450A, { 0x9D, 0x0F, 0xF4, 0x7A, 0xB9, 0x7C, 0x3D, 0xEA } };

#endif

// {7DCD9F7B-9080-4F5B-A26C-3470BE2CAA7A}
static const GUID DsmFlashLedType =
{ 0x7DCD9F7B, 0x9080, 0x4F5B, { 0xA2, 0x6C, 0x34, 0x70, 0xBE, 0x2C, 0xAA, 0x7A } };


// 82C0D13A-78C5-4244-9BB1-EB8B539A8D11
static const GUID DsmFunctionSnsrMclk =
{0x82C0D13A, 0x78C5, 0x4244, {0x9B, 0xB1, 0xEB, 0x8B, 0x53, 0x9A, 0x8D, 0x11} };

// 02F55F0C-2E63-4F05-84F3-BF1980F9AF79
static const GUID DsmCameraCVF =
{ 0x02F55F0C, 0x2E63, 0x4F05, {0x84, 0xF3, 0xBF, 0x19, 0x80, 0xF9, 0xAF, 0x79} };

// {6665D1CE-20A3-40D0-99A1-E488DB5AF908}
static const GUID DsmFlashId =
{ 0x6665D1CE, 0x20A3, 0x40D0, { 0x99, 0xA1, 0xE4, 0x88, 0xDB, 0x5A, 0xF9, 0x08 } };


#define I2C_GENERAL          0
#define I2C_VCM              1
#define I2C_EEPROM           2
#define I2C_EXT1             3
#define I2C_EXT2             4
#define I2C_EXT3             5
#define I2C_EXT4             6
#define I2C_EXT5             7
#define I2C_EXT6             8
#define I2C_EXT7             9
#define CHT_I2C_NUM          10

/*********************************/
//for Skycam, I2C index define need to match with BIOS
#define I2C_IO_EXPANDER      10
#define I2C_PMIC             11
#define I2C_FLASH            12
#define I2C_CSI_BRIDGE       13
#define SKC_I2C_NUM          14
/**********************************/
#define I2C_NUM (max(CHT_I2C_NUM, SKC_I2C_NUM))


#define I2C_SPEED_400000     0
#define I2C_SPEED_100000     1

#define I2C_TIMEOUT_IN_MS    8000

#define GPIO_RESET           0
#define GPIO_PWDN            1
#define GPIO_STROBE          2
#define GPIO_TORCH           3
#define GPIO_FLASH           4
#define GPIO_INDICATOR_REAR  5
#define GPIO_INDICATOR_FRONT 6
#define GPIO_POWER0          7
#define GPIO_POWER1          8
#define GPIO_STANDBY         9
#define GPIO_WP              10
#define GPIO_NUM             11


/*********************************/
//for Skycam, GPIO index define need to match with BIOS

//for GPIO_POWER_EN
//It is used to power up all the power rails of the camera.
//SKC  only supports camera that allow all power rails to be pweored up at the same time.
//For some cameras, Power_En will turn on Core, Analog and IO Power.  For others, Corem, Analog, IO and VCM.
#define GPIO_POWER_EN        11

#define GPIO_MCLK            12
#define GPIO_PRIVATE_LED     13
#define GPIO_AF              14
#define GPIO_IO              15
#define GPIO_AVDD            16
#define GPIO_CORE            17
#define GPIO_HANDSHAKE       18
#define GPIO_INT_IO          19    // used for HDMI-MIPI converter status change (input pin)
#define GPIO_HDMI_DETECT     20    // used for HDMI-MIPI converter (input pin)
#define SKC_GPIO_NUM         21
/**********************************/


#define VPROG_1              0
#define VPROG_2              1
#define VPROG_1_2            2

#define MIPI_LANE_1          1
#define MIPI_LANE_2          2
#define MIPI_LANE_3          3
#define MIPI_LANE_4          4

#define MIPI_IN_DRIVER       0
#define MIPI_IN_ACPI         1

#define DEGREE_0             0
#define DEGREE_180           1

#define FLASH_DEFAULT        0
#define FLASH_DISABLE        2
#define FLASH_ENABLE         3

#define FUNC_MASK_ORIENTATION  0x3
#define FUNC_MASK_FLASH        (0x3 << 2)

#define ROM_NONE                0
#define ROM_OTP                 1
#define ROM_EEPROM              2
#define ROM_OTP_ACPI_ACPI       4 //both OTP and ACPI read supported, choose read from ACPI
#define ROM_ACPI                5 //read sensor calibration data from ACPI
#define ROM_EEPROM_BRCA016GWZ   6
#define ROM_EEPROM_24AA32       7
#define ROM_EEPROM_CAT24C08     8
#define ROM_EEPROM_M24C64       9
#define ROM_EFLASH_DW9806B      10
#define ROM_EEPROM_CAT24C16     16
#define ROM_EEPROM_CAT24C64     17
#define ROM_EEPROM_24AA16         18
#define ROM_IVCAM               0xFF
#define ROM_MAX                 12


#define FLISCLK_1            0
#define FLISCLK_2            1

#define HWID_LENGTH          16
#define STRING_LENGTH        16
#define CALIBRATION_LENGTH   545
#define DSDT2INFO_LENGTH     32

typedef struct __DSDT2_INFO_
{
    UINT8 MipiDefine;       // 0-mipi defined in driver; 1-mipi defined in dsm
    UINT8 MipiPort;         // 0-port0; 1-port1; 2-port2
    UINT8 MipiLanes;        // 0-n/a; 1-1lanes; 2-2lanes; 3-3lanes; 4-4lanes
    UINT8 MipiDataFormat;   // raw8, raw10, raw12, yuv,...
    UINT8 FlashSupport;     // 0-flash support defined in driver;
    UINT8 Degree;           // 0-0degree; 1-180degree
    UINT8 NVRAM;
    UINT8 VCM;
    UINT8 Platform;
    UINT8 PlatformSub;
    UINT8 Silicon;
    UINT8 Customer;
    UINT8 NvmInfoDefine;
    UINT8 NvmInfoPage;
    UINT16 NvmInfoSize;
    UINT8 Power;
    UINT8 Clock;
    UINT8 Reserved[14];
}DSDT2_INFO;

typedef union __DSDT_GPIO_SETTING__
{
    struct {
        UCHAR Function;
        UCHAR Number;
        UCHAR InitValue;
        UCHAR ActiveValue;
    } GPIO_CONFIG;
    ULONG AsUlong;
}DSDT_GPIO_SETTING;

typedef struct __DSDT_GPIO__
{
    ULONG Count;
    DSDT_GPIO_SETTING GpioSet[GPIO_NUM];
}DSDT_GPIO;

typedef union __DSDT_I2C_SETTING__
{
    struct {
        UCHAR Function;
        UCHAR SlaveAddress;
        UCHAR Speed;
        UCHAR Bus;
    } I2C_CONFIG;
    ULONG AsUlong;
}DSDT_I2C_SETTING;

typedef struct __DSDT_I2C__
{
    ULONG Count;
    DSDT_I2C_SETTING I2cSet[I2C_NUM];
}DSDT_I2C;

typedef struct __DSDT2_CAMERA_SETTINGS__
{
    ULONG InterfaceVersion;
    DSDT_GPIO Gpio;
    DSDT_I2C I2c;
    DSDT2_INFO Info;
    UCHAR HardwareId[HWID_LENGTH];
    UCHAR ModuleName[STRING_LENGTH];
    UCHAR PlatInfo[STRING_LENGTH];
    UCHAR PlatSubInfo[STRING_LENGTH];
    UCHAR CustomerInfo[STRING_LENGTH];
    UCHAR SiliconInfo[STRING_LENGTH];
    UCHAR VcmName[STRING_LENGTH];
}DSDT2_CAMERA_SETTINGS;

typedef struct __DSDT_CAMERA_SETTINGS__
{
    ULONG InterfaceVersion;
    UCHAR HardwareId[HWID_LENGTH];
    UCHAR ModuleName[STRING_LENGTH];
    UCHAR PlatInfo[STRING_LENGTH];
    UCHAR VcmName[STRING_LENGTH];
    UCHAR PmicInfo[STRING_LENGTH];
    UCHAR BoardType[STRING_LENGTH];
    ULONG PmicLinkInfo;
    ULONG Mclk;        // like 19200000 -> 19.2MHz
    DSDT_GPIO Gpio;
    DSDT_I2C I2c;
    ULONG MipiInfo;
    ULONG Function;
    UCHAR RomType;
    UCHAR VprogIndex;
    UCHAR MclkIndex;   // clock port index
    UCHAR Reserved[1];
}DSDT_CAMERA_SETTINGS;


#define FLASH_HEAT_MASK 0x1
#define FLASH_HEAT_SHIFT 0
#define FLASH_PEAK_LIMIT_MASK 0x7
#define FLASH_PEAK_LIMIT_SHIFT 1
typedef struct __DSDT_FLASH_SETTINGS__
{
    UCHAR HardwareId[HWID_LENGTH];
    UCHAR ModuleName[STRING_LENGTH];
    UCHAR PlatInfo[STRING_LENGTH];
    DSDT_GPIO Gpio;
    DSDT_I2C I2c;
    ULONG Function;
    ULONG LedType;
    ULONG FlashId;
}DSDT_FLASH_SETTINGS;

//platform information
#define PLATFORM_Unknown   0
#define PLATFORM_BYT       1
#define PLATFORM_CHT       2
#define PLATFORM_CHT1      3 // for CHT1
#define PLATFORM_CHT2      4 // for CHT2
#define PLATFORM_CHT_CR    5
#define PLATFORM_CHT_COPOP 6
#define PLATFORM_BSW       7
#define PLATFORM_BXT       8
#define PLATFORM_SKC       9
#define PLATFORM_CNL       10
#define PLATFORM_LKF       11
#define PLATFORM_TGL       12
#define PLATFORM_TGL_H     13
#define PLATFORM_JSLP      14
#define PLATFORM_ADL       15
#define PLATFORM_MTL       16
#define PLATFORM_LNL       17

//CHT
#define PLATFORMSUB_Unknown 0
#define PLATFORMSUB_FFD     1   // for Platform FFD/RVP
#define PLATFORMSUB_CHT1    2   // for CHT1
#define PLATFORMSUB_CHT2    3   // for CHT2

//SKC
#define PLATFORMSUB_SKC1    1   // for Platform SKC1

//ICL
#define PLATFORMSUB_ICL     1   // for Platform ICL

//Customer information
#define CUSTOMER_INTEL       0
#define CUSTOMER_MS          1
#define CUSTOMER_LENOVO      2
#define CUSTOMER_ASUS        3
#define CUSTOMER_ACER        4
#define CUSTOMER_HP          5
#define CUSTOMER_SUMSANG     6
#define CUSTOMER_NCR         7

#define PRIVACY_LED_DEFAULT  0
#define PRIVACY_LED_A_16mA   1
#define PRIVACY_LED_B_2mA    2
#define PRIVACY_LED_B_4mA    3
#define PRIVACY_LED_B_8mA    4
#define PRIVACY_LED_B_16mA   5

#define SENSOR_VOLTAGE_RAIL_3 0
#define SENSOR_VOLTAGE_RAIL_2 1



//CNL PCH sensor clock
#define PCH_IMG_CLK_0        0   //GPPC_D_4
#define PCH_IMG_CLK_1        1   //GPPC_H_20
#define PCH_IMG_CLK_2        2   //GPPC_H_21
#define PCH_IMG_CLK_3        3   //GPPC_H_22
#define PCH_IMG_CLK_4        4   //GPPC_H_23
#define PCH_IMG_CLK_5        5   //GPPC_D_15


#define PCH_DISABLE_CLK      0
#define PCH_ENABLE_CLK       1

#define PCH_CLK_FREQ_24M     0
#define PCH_CLK_FREQ_19M     1
     

#endif
