::*************************************************************************************************
:: INTEL CONFIDENTIAL Copyright 2011-2022 Intel Corporation All Rights Reserved.
::
:: The source code contained or described herein and all documents related to the source code
:: ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
:: remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
:: and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
:: protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
:: Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
:: distributed, or disclosed in any way without Intel's prior express written permission.
::
:: No license under any patent, copyright, trade secret or other intellectual property right is
:: granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
:: implication, inducement, estoppel or otherwise. Any license under such intellectual property
:: rights must be express and approved by Intel in writing.
::*************************************************************************************************/

@echo off
setlocal

set curdirectory=%~dp0
set CameraDDK_dir=CameraDDK
set Sensor_dir=Sensor
set Last_dir=..\
set BuildDir=%cd%

::DDK sensor path
set DdkSensorDir=%curdirectory%%Last_dir%%Sensor_dir%


::Sample
::set Sample=ov08x40
set Sample=Sample
set SampleProjFile=%Sample%.vcxproj
set SampleProjFilePath=%DdkSensorDir%\%Sample%

::set CopyBinAndCPF Dest Folder
set BinplacePath=
set DrvPkgDirName=

::compile define
set MsbuildTool=C:\Program Files (x86)\Microsoft Visual Studio\2019\Professional\MSBuild\Current\Bin\MSBuild.exe

if "%1" == "" (
    set "BuildType=ALL"
    goto build_all
)else if "%1"=="TGL" (
    set "BuildType=TGL"
    goto build_tgl
)else if "%1"=="ADL" (
    set "BuildType=ADL"
    goto build_adl
)else (
    echo Parameter error..
    echo BuildCameraSensor.bat TGL:    build TGL platform
    echo BuildCameraSensor.bat ADL:    build ADL platform
  exit /b
)


:build_all

:build_tgl
set PLAT_FORM=TGL

::build Sample
if exist "%SampleProjFilePath%\%SampleProjFile%" (
::    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)

if %BuildType%==ALL (
    goto build_adl
) else (
    goto build_end
)

:build_adl
set PLAT_FORM=ADL

::build Sample
echo %SampleProjFilePath%\%SampleProjFile%

if exist "%SampleProjFilePath%\%SampleProjFile%" (
::    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)

:build_end
::cd %BuildDir%
exit /b