//*****************************************************************************
// INTEL CORPORATION PROPRIETARY INFORMATION
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Intel Corporation and may not be
// copied or disclosed except in accordance with the terms of that
// agreement
//
// Copyright 2020 Intel Corporation. All Rights Reserved.
//*****************************************************************************

// The EEPROM is DW9808

#ifndef __EEPROM_DW9808__
#define __EEPROM_DW9808__

// [TODO] EEPROM

#define DW9808_PAGE_SIZE  64     //Column address 0x00 to 0x3F
#define DW9808_PAGE_NUM   160    //Page 0x00 to 0x9F
#define DW9808_SIZE       (DW9808_PAGE_SIZE * DW9808_PAGE_NUM) //10Kbyte
#define DW9808_ADDR_MIN   0
#define DW9808_ADDR_MAX   (DW9808_SIZE - 1)

NTSTATUS
Cmd_DW9808Write(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8 *pData,
    INT32 Length
);

NTSTATUS
Cmd_DW9808Read(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8 *pData,
    INT32 Length
);

#endif __EEPROM_DW9808__
