/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is dw9719
#ifndef __VCM_DW9719__
#define __VCM_DW9719__

#define DW9719_DEFAULT_POS    1
#define DW9719_MIN_FOCUS_POS        0    
#define DW9719_MAX_FOCUS_POS        1023
#define DW9719_VCM_RUN_STEPS        32
#define DW9719_VCM_RESET_DELAY      5
#define DW9719_VCM_IC_INFO          0x00
#define DW9719_VCM_CODE_MSB         0x03
#define DW9719_VCM_CODE_LSB         0x04
#define DW9719_VCM_STATUS           0x05

NTSTATUS DW9719_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9719_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9719_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS DW9719_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS DW9719_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS DW9719_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS DW9719_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

NTSTATUS DW9719_Test(
    PVCM_CONTEXT pSsVcm
    );

#endif __VCM_DW9719__
