/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is DW9808
#ifndef __VCM_DW9808__
#define __VCM_DW9808__

// VCM configuration
#define DW9808_DEFAULT_POS          400
#define DW9808_MIN_FOCUS_POS        10    //150
#define DW9808_MAX_FOCUS_POS        1023 //350
#define DW9808_HOME_FOCUS_POS       DW9808_MIN_FOCUS_POS
#define DW9808_VCM_DOWN_STEPS       32
#define DW9808_VCM_WARMUP_STEPS     32
#define DW9808_VCM_UP_INERTIA       50
#define DW9808_VCM_DOWN_INERTIA     90
#define DW9808_VCM_DIST_FAR_HOME    140
#define DW9808_VCM_RESET_DELAY      10

// VCM registers
//#define DW9808_VCM_IC_INFO          0x00

#define DW9808_VCM_CONTROL          0x02 //default 0x00

#define DW9808_VCM_CODE_MSB         0x03 //default 0x00
#define DW9808_VCM_CODE_LSB         0x04 //default 0x00
#define DW9808_VCM_STATUS           0x05 //default 0x00

#define DW9808_VCM_SAC_PRESCALE     0x06 //default 0x01
#define DW9808_VCM_SACT             0x07 //default 0x20
#define DW9808_VCM_PRESET           0x0A //default 0x00
#define DW9808_VCM_NRC              0x0B //default 0x00
#define DW9808_VCM_NRC_STEP         0x0C //default 0x85
#define DW9808_VCM_MPK              0x10 //default 0x00





extern S_SETTING DW9808VcmConfigration[];

NTSTATUS DW9808_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9808_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9808_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS DW9808_WarmStart(
    PVCM_CONTEXT pDevExt
    );

NTSTATUS DW9808_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS DW9808_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS DW9808_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS DW9808_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

NTSTATUS DW9808_Test(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9808_NRC(
    PVCM_CONTEXT pSsVcm
    );

#endif __VCM_DW9808__
