/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2021 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is LC898217
#ifndef __VCM_LC898217__
#define __VCM_LC898217__

#define LC898217_DEFAULT_POS          0x1AC
#define LC898217_MIN_FOCUS_POS        0
#define LC898217_MAX_FOCUS_POS        0x3FF
#define LC898217_HOME_FOCUS_POS       LC898217_DEFAULT_POS
#define REG_LC898217_SET_POS          0x84
#define REG_LC898217_GET_POS          0x0A
#define REG_LC898217_SLAVE_ADDRESS    0xF0
#define LC898217_SLAVE_ADDRESS        0x72
#define REG_LC898217_DOWN_LOAD        0xE0
#define LC898217_OPERATION_DONE       0x00
#define LC898217_OPERATION_START      0x01
#define REG_LC898217_LSI_WAKE         0xB3

NTSTATUS LC898217_Init(
    PVCM_CONTEXT SensorCtx
    );

NTSTATUS LC898217_ResetPos(
    PVCM_CONTEXT SensorCtx
    );

NTSTATUS LC898217_SetPos(
    PVCM_CONTEXT SensorCtx,
    USHORT FocusPos
    );

NTSTATUS LC898217_GetPos(
    PVCM_CONTEXT SensorCtx,
    USHORT *FocusPos
    );

NTSTATUS LC898217_GetStatus(
    PVCM_CONTEXT SensorCtx,
    PULONG Status
    );

NTSTATUS LC898217_GetHPStatus(
    PVCM_CONTEXT SensorCtx,
    PULONG Status
    );

NTSTATUS LC898217_SetConfig(
    PVCM_CONTEXT SensorCtx,
    SNSR_VCMDATA *pSnsrVcmData
    );

#endif __VCM_LC898217__
